% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculategphmm}
\alias{calculategphmm}
\title{Calculate GPHMM probability.}
\usage{
calculategphmm(x, y, tau, pp, qX, qY, dX, dY, eX, eY)
}
\arguments{
\item{x}{string, with the sequence of the read.}

\item{y}{string, with the sequence of the reference.}

\item{tau}{double, probability to transition from any state to end state.}

\item{pp}{matrix, emission probabilities in the M state.}

\item{qX}{vector, emission probabilities in the insertion state.}

\item{qY}{vector, emission probabilities in the deletion state.}

\item{dX}{double, transition probability from the M to the insertion state.}

\item{dY}{double, transition probability from the M to the deletion state.}

\item{eX}{double, transition probability from the insertion to the insertion state.}

\item{eY}{double, transition probability from the deletion to the deletion state.}
}
\description{
This function returns the GPHMM probability that a read x could have been
sequenced from a reference sequence y.
}
\examples{
param <- initializeGphmm()
tau <- param[['tau']]
pp <- param[['pp']]
qX <- param[['qX']]
qY <- param[['qY']]
dX <- 1/(1+exp(-sum(param[['deltaX']] * c(1, 20))))
dY <- 1/(1+exp(-sum(param[['deltaY']] * c(1, 20))))
eX <- param[['epsX']]
eY <- param[['epsY']]
calculategphmm('ATCG', 'ATGG', tau, pp, qX, qY, dX, dY, eX, eY)
}
