% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainGPHMM.R
\name{computeGphmmParam}
\alias{computeGphmmParam}
\title{Compute gphmm parameters from counts.}
\usage{
computeGphmmParam(emiTrans)
}
\arguments{
\item{emiTrans}{- list with emission and transition counts.}
}
\description{
\code{computeGphmmParam} returns a list with gphmm parameters.
}
\examples{
library(Biostrings)
seqs <- DNAStringSet(c(a='ATGC', b = 'ATGG', c = 'ATGT'))
csv <- data.frame(queries = c('a', 'b'), refs = c('c', 'c'))
gphmmPerRead <- makeGphmmPerRead(seqs, csv)
parameters <- initializeGphmm()
counts <- lapply(1:nrow(csv), function(i) gphmmPerRead(i, parameters))
computeGphmmParam(counts)
}
