% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{getIntern}
\alias{getIntern}
\title{Generic Extraction Function}
\usage{
getIntern(gpModel, quantity)
}
\arguments{
\item{gpModel}{object of class GPPM.}

\item{quantity}{character string. Name of the quantity to extract. Possible values are
\itemize{
\item "parsedmFormula" for the parsed mean formula
\item "parsedcFormula" for the parsed covariance formula
\item "stanData" for the data set in the form needed for rstan
\item "stanModel" for the created rstan model
\item "stanOut" for the created stan output
}}
}
\value{
The requested quantity
}
\description{
Extracts internals from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
lgcmFit <- fit(lgcm)
getIntern(lgcmFit,'parsedmFormula')
}
}
\seealso{
Other functions to extract from a GPPM: \code{\link{SE}},
  \code{\link{coef.GPPM}}, \code{\link{confint.GPPM}},
  \code{\link{covf}}, \code{\link{datas}},
  \code{\link{fitted.GPPM}}, \code{\link{logLik.GPPM}},
  \code{\link{maxnObs}}, \code{\link{meanf}},
  \code{\link{nObs}}, \code{\link{nPars}},
  \code{\link{nPers}}, \code{\link{nPreds}},
  \code{\link{parEsts}}, \code{\link{pars}},
  \code{\link{preds}}, \code{\link{vcov.GPPM}}
}
