% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpt_queries.R
\name{gpt_chat_in_source}
\alias{gpt_chat_in_source}
\title{ChatGPT in Source}
\usage{
gpt_chat_in_source(
  history = NULL,
  style = getOption("gptstudio.code_style"),
  skill = getOption("gptstudio.skill")
)
}
\arguments{
\item{history}{A list of the previous chat responses}

\item{style}{A character string indicating the preferred coding style, the
default is "tidyverse".}

\item{skill}{The self-described skill level of the programmer,
default is "beginner"}
}
\value{
A list containing the instructions for answering the question, the
context in which the question was asked, and the suggested answer.
}
\description{
Provides the same functionality as \code{gpt_chat()} with minor modifications to
give more useful output in a source (i.e., *.R) file.
}
\examples{
\dontrun{
# Example 1: Get help with a tidyverse question in a source file
# Select the following code comment in RStudio and run gpt_chat_in_source()
# How can I filter rows of a data frame?
tidyverse_response <- gpt_chat_in_source(style = "tidyverse",
                                         skill = "beginner")

# Example 2: Get help with a base R question in a source file
# Select the following code comment in RStudio and run gpt_chat_in_source()
# How can I merge two data frames?
base_r_response <- gpt_chat_in_source(style = "base", skill = "intermediate")

# Example 3: No style preference in a source file
# Select the following code comment in RStudio and run gpt_chat_in_source()
# What is the best way to handle missing values in R?
no_preference_response <- gpt_chat_in_source(style = "no preference",
                                             skill = "advanced")
}

}
