% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gquadO.R
\name{gquadO}
\alias{gquadO}
\title{Predicting G quadruplexes including overlaps}
\usage{
gquadO(x, xformat = "default")
}
\arguments{
\item{x}{nucleotide sequence(s) in raw format or a fasta file or a GenBank accession number(s); from which G quadruplexes (including overlaps) will be predicted.
If the fasta file name does not contain an absolute path, the file name is relative to the current working directory.}

\item{xformat}{a character string specifying the format of x : default (raw), fasta, GenBank (GenBank accession number(s)).}
}
\value{
A dataframe of G quadruplexes' position, sequence, length and likeliness. If more than one nucleotide sequence is provided as argument, an input ID is returned for motif(s) predicted from each input sequence.
}
\description{
This function predicts G quadruplexes
in 'x' (nucleotide sequence(s)) like the gquad function, but includes overlaps.
Nucleotide sequence can be provided in raw or fasta format or as GenBank accession number(s).
Internet is needed to connect to GenBank database, if accession number(s) is given as argument.
}
\details{
This function predicts G quadruplexes in nucleic (both DNA and RNA) sequences, including overlaps and provide the position, sequence and length of the predicted motif(s). If any motif is predicted, the degree of likeliness for the motif to be formed is computed and scored as ** (more likely) or as * (less likely).
}
\examples{
## Predicting G quadruplexes (including overlaps) from raw nucleotide sequences
E1 <- c("TCTTGGGCATCTGGAGGCCGGAAT", "taggtgctgggaggtagagacaggatatcct")
gquadO(E1)

## Predicting G quadruplexes (including overlaps) from nucleotide sequences in fasta file
## Not run: gquadO(x="Example.fasta", xformat = "fasta")

## Predicting G quadruplexes (including overlaps) from nucleotide sequences,
## using GenBank accession numbers.
## Internet connectivity is needed for this to work.
## Not run: gquadO(c("BH114913", "AY611035"), xformat = "GenBank")
}
\references{
paper under review
}
\seealso{
gquad
}
\author{
Hannah O. Ajoge
}
