% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.Methods.R
\name{GD}
\alias{GD}
\title{Gradient Descent (GD) Method Learning Function}
\usage{
GD(dataTrain, alpha = 0.1, maxIter = 10, seed = NULL)
}
\arguments{
\item{dataTrain}{a data.frame that representing training data (\eqn{m \times n}),
where \eqn{m} is the number of instances and \eqn{n} is the number
of variables where the last column is the output variable. dataTrain
must have at least two columns and ten rows of data that contain
only numbers (integer or float).}

\item{alpha}{a float value representing learning rate. Default value is 0.1}

\item{maxIter}{the maximal number of iterations.}

\item{seed}{a integer value for static random. Default value is NULL, which means
the function will not do static random.}
}
\value{
a vector matrix of theta (coefficient) for linear model.
}
\description{
A function to build prediction model using Gradient Descent method.
}
\details{
This function build a prediction model using Gradient Descent (GD) method.
Gradient Descent is a first order optimization algorithm to find a local
minimum of an objective function by searching along the steepest descent
direction. In machine learning, it is mostly used for dealing with supervised
learning, which is regression task. By using GD, we construct a model
represented in a linear equation that maps the relationship between input
variables and the output one. In other words, GD determines suitable coefficient
of each variables. So, that the equation can express the mapping correctly.
}
\examples{
##################################
## Learning and Build Model with GD
## load R Package data
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## split dataset
splitedDataSet <- splitData(dataSet)
## build model with GD
GDmodel <- GD(splitedDataSet$dataTrain)
#show result
print(GDmodel)

}
\references{
L.A. Cauchy,
"Methode generale pour la resolution des systemes d equations",
Compte Rendu a l Academie des Sciences 25,
pp. 536-538 (1847)
}
\seealso{
\code{\link{MBGD}}
}
