% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{FitKineticsGeneLogSpaceLinear}
\alias{FitKineticsGeneLogSpaceLinear}
\title{Fit a kinetic model using a linear model.}
\usage{
FitKineticsGeneLogSpaceLinear(
  data,
  gene,
  slot = DefaultSlot(data),
  time = Design$dur.4sU,
  CI.size = 0.95
)
}
\arguments{
\item{data}{A grandR object}

\item{gene}{The gene for which to fit the model}

\item{slot}{The data slot to take expression values from}

\item{time}{The column in the column annotation table representing the labeling duration}

\item{CI.size}{A number between 0 and 1 representing the size of the confidence interval}
}
\value{
A named list containing the model fit:
\itemize{
  \item{data: a data frame containing the observed value used for fitting}
  \item{Synthesis: the synthesis rate (in U/h, where U is the unit of the slot)}
  \item{Degradation: the degradation rate (in 1/h)}
  \item{Half-life: the RNA half-life (in h, always equal to log(2)/degradation-rate}
  \item{conf.lower: a vector containing the lower confidence bounds for Synthesis, Degradation and Half-life}
  \item{conf.upper: a vector containing the lower confidence bounds for Synthesis, Degradation and Half-life}
  \item{f0: The abundance at time 0 (in U)}
  \item{logLik: the log likelihood of the model}
  \item{rmse: the total root mean square error}
  \item{adj.r.squared: adjusted R^2 of the linear model fit}
  \item{total: the total sum of all new and old RNA values used for fitting}
  \item{type: always "lm"}
}
If \code{Condition(data)} is not NULL, the return value is a named list (named according to the levels of \code{Condition(data)}), each
element containing such a structure.
}
\description{
Fit the standard mass action kinetics model of gene expression using a linear model after log-transforming the observed values
(i.e. assuming gaussian homoscedastic errors of the logarithmized values) for the given gene.
The fit takes only old RNA into account and requires proper normalization, but can be performed without assuming steady state for the degradation rate.
The parameters are fit per \link{Condition}.
}
\details{
The start of labeling for all samples should be the same experimental time point. The fit gets more precise with multiple samples from multiple
labeling durations. Also a sample without 4sU (representing time 0) is useful.

The standard mass action kinetics model of gene expression arises from the following differential equation:

\deqn{df/dt = s - d  f(t)}

This model assumes constant synthesis and degradation rates (but not necessarily that the system is in steady state at time 0).
From the solution of this differential equation, it is straight forward to derive the expected abundance of old and new RNA at time t
for given parameters s (synthesis rate), d (degradation rate) and f0=f(0) (the abundance at time 0). These equations are implemented in
\code{\link{f.old.equi}} (old RNA assuming steady state gene expression, i.e. f0=s/d),
\code{\link{f.old.nonequi}} (old RNA without assuming steady state gene expression) and
\code{\link{f.new}} (new RNA; whether or not it is steady state does not matter).

This function primarily finds d such that the squared error between the observed values of old and new RNA and their corresponding functions
is minimized in log space. For that to work, data has to be properly normalized, but this is independent on any steady state assumptions. The synthesis
rate is computed (under the assumption of steady state) as \eqn{s=f0 \cdot d}
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Condition",Design$dur.4sU,Design$Replicate))
sars <- Normalize(sars)
FitKineticsGeneLogSpaceLinear(sars,"SRSF6")   # fit per condition

}
\seealso{
\link{FitKinetics}, \link{FitKineticsGeneLeastSquares}, \link{FitKineticsGeneNtr}
}
\concept{kinetics}
