% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{ComputeSteadyStateHalfLives}
\alias{ComputeSteadyStateHalfLives}
\title{Steady state half-lives for each sample}
\usage{
ComputeSteadyStateHalfLives(
  data,
  time = Design$dur.4sU,
  name = "HL",
  columns = NULL,
  max.HL = 48,
  CI.size = 0.95,
  compute.CI = FALSE,
  as.analysis = FALSE
)
}
\arguments{
\item{data}{the grandR object}

\item{time}{either a number indicating the labeling time, or a name of the \link{Coldata} table}

\item{name}{the name of the new slot/analysis to put half-life values in}

\item{columns}{which columns (i.e. samples or cells) to return; sets as.analysis to TRUE (see details)}

\item{max.HL}{all values above this will be set to this}

\item{CI.size}{A number between 0 and 1 representing the size of the credible interval}

\item{compute.CI}{it TRUE, credible intervals are computed, this also sets as.analysis to TRUE}

\item{as.analysis}{if TRUE add the results as analysis and not as data slot}
}
\value{
a new grandR object with an additional slot or analysis
}
\description{
Transforms each NTR to a half-life value (assuming steady state gene expression) and puts them into a new slot or adds an analysis
}
\details{
An NTR value p can be transformed into an RNA half-live using the equation
log(2)/(-1/t*log(1-p))
This is described in our GRAND-SLAM paper (Juerges et al., Bioinformatics 2018).

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment havin the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\concept{snapshot}
