% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readsimulator.R
\name{SimulateTimeCourseNonConstant}
\alias{SimulateTimeCourseNonConstant}
\title{Simulate a complete time course of metabolic labeling - nucleotide conversion RNA-seq data.}
\usage{
SimulateTimeCourseNonConstant(
  condition,
  gene.info,
  s,
  d,
  dispersion,
  num.reads = 1e+07,
  t = 2,
  replicates = 3,
  beta.approx = FALSE,
  conversion.reads = FALSE,
  verbose = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{condition}{A user-defined condition name (which is placed into the \code{\link{Coldata}} of the final grandR object)}

\item{gene.info}{either a data frame containing gene annotation or a vector of gene names}

\item{s}{a vector of synthesis rates (see details)}

\item{d}{a vector of degradation rates (see details)}

\item{dispersion}{a vector of dispersion parameters (estimate from data using DESeq2, e.g. by the estimate.dispersion utility function)}

\item{num.reads}{a vector representing the number of reads for each sample}

\item{t}{a single number denoting the time}

\item{replicates}{a single number denoting the number of replicates}

\item{beta.approx}{should the beta approximation of the NTR posterior be computed?}

\item{conversion.reads}{also output the number of reads with conversion}

\item{verbose}{Print status updates}

\item{seed}{seed value for the random number generator (set to make it deterministic!)}

\item{...}{provided to \code{\link{SimulateReadsForSample}}}
}
\value{
a grandR object containing the simulated data in its data slots and the true parameters in the gene annotation table
}
\description{
This function takes a vector of \emph{true} synthesis rates and RNA half-lives, and then simulates
data for multiple time points and replicates. Both synthesis rate and RNA half-lives are assumed to be constant,
but the system might not be in steady-state.
}
\details{
Both rates can be either (i) a single number (constant rate), (ii) a data frame with names "offset",
"factor" and "exponent" (for linear functions, see \link{ComputeNonConstantParam}; only one row allowed) or
(iii) a unary function time->rate. Functions
}
\seealso{
\link{SimulateTimeCourse}
}
\concept{simulation}
