% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_max_corr.R
\name{dist_max_corr}
\alias{dist_max_corr}
\title{Compute the distance at which the correlation between genetic distance
and landscape distance is maximal}
\usage{
dist_max_corr(
  mat_gd,
  mat_ld,
  interv,
  from = NULL,
  to = NULL,
  fig = TRUE,
  thr_gd = NULL,
  line_col = "black",
  pts_col = "#999999"
)
}
\arguments{
\item{mat_gd}{A symmetric \code{matrix} with pairwise genetic distances
between populations or sample sites.}

\item{mat_ld}{A symmetric \code{matrix} with pairwise landscape distances
between populations or sample sites. These distances can be
Euclidean distances, cost-distances or resistance distances, among others.}

\item{interv}{A numeric value indicating the interval between the different
distance thresholds for which the correlation coefficients are computed.}

\item{from}{(optional) The minimum distance threshold value at which the
correlation coefficient is computed.}

\item{to}{(optional) The maximum distance threshold value at which the
correlation coefficient is computed.}

\item{fig}{Logical (default = TRUE) indicating whether a figure is plotted.}

\item{thr_gd}{(optional) A numeric value used to remove
genetic distance values from the data before the calculation.
All genetic distances values above 'thr_gd' are removed from the data.
This parameter can be used especially when there are outliers.}

\item{line_col}{(optional, if fig = TRUE) A character string indicating the
color used to plot the line (default: "blue"). It must be a hexadecimal color
code or a color used by default in R.}

\item{pts_col}{(optional, if fig = TRUE) A character string indicating the
color used to plot the points (default: "#999999"). It must be a hexadecimal
color code or a color used by default in R.}
}
\value{
A list of objects:
\itemize{
\item{The distance at which the correlation is the highest.}
\item{The vector of correlation coefficients at the different
distance thresholds}
\item{The vector of the different distance thresholds}
\item{A ggplot2 object to plot}
}
}
\description{
The function enables to compute the distance at which the
correlation between genetic distance and landscape distance is maximal,
using a method similar to that employed by van Strien et al. (2015).
Iteratively, distance threshold values are tested. For each value, all the
population pairs separated by a landscape distance larger than the threshold
are removed before the Mantel correlation coefficient between genetic
distance and landscape distance is computed.
The distance threshold at which the correlation is the strongest is then
identified. A figure showing the evolution of the correlation coefficients
when landscape distance threshold increases is plotted.
}
\details{
IDs in 'mat_gd' and 'mat_ld' must be the same and refer to the same
sampling sites or populations, and both matrices must be ordered
in the same way.
The correlation coefficient between genetic distance and landscape distance
computed is a Mantel correlation coefficient. If there are less than 50
pairwise values, the correlation is not computed, as in
van Strien et al. (2015). Such a method can be subject to criticism from
a strict statistical point of view given correlation coefficients computed
from samples of different size are compared.
The matrix of genetic distance 'mat_gd' can be computed using
\code{\link{mat_gen_dist}}.
The matrix of landscape distance 'mat_ld' can be computed using
\code{\link{mat_geo_dist}} when the landscape distance needed is a
Euclidean geographical distance.
Mantel correlation coefficients are computed using
the function \code{\link[vegan]{mantel}}.
}
\examples{
data("data_tuto")
mat_gen <- data_tuto[[1]]
mat_dist <- data_tuto[[2]]*1000
res_dmc <- dist_max_corr(mat_gd = mat_gen,
                         mat_ld = mat_dist,
                         from = 32000, to = 42000,
                         interv = 5000,
                         fig = FALSE)
}
\references{
\insertRef{van2015isolation}{graph4lg}
}
\author{
P. Savary
}
