% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genepop_to_genind.R
\name{genepop_to_genind}
\alias{genepop_to_genind}
\title{Convert a GENEPOP file into a genind object}
\usage{
genepop_to_genind(path, n.loci, pop_names = NULL, allele.digit.coding = 3)
}
\arguments{
\item{path}{A character string with the path leading to the GENEPOP file
in format .txt, or alternatively the name of this file in the working
directory.}

\item{n.loci}{The number of loci in the GENEPOP file (integer or numeric).}

\item{pop_names}{(optional) Populations' names in the same order
as in the GENEPOP file.
Vector object (class character) of the same length as the number
of populations.
Without this parameter, populations are numbered from 1 to the number
of populations.}

\item{allele.digit.coding}{Number indicating whether alleles are coded
with 3 (default) or 2 digits.}
}
\value{
An object of type \code{genind}.
}
\description{
The function converts a text file in the format used by GENEPOP
software into a genind object
}
\details{
This function uses functions from \pkg{pegas} package.
GENEPOP file should can include microsatellites loci or SNPs with allele names
of length 2 or 3 (noted as 01, 02, 03 or 04 for SNPs).
The loci line(s) must not start with a spacing.
}
\examples{
path_in <- system.file('extdata', 'gpop_simul_10_g100_04_20.txt',
                       package = 'graph4lg')
file_n <- file.path(tempdir(), "gpop_simul_10_g100_04_20.txt")
file.copy(path_in, file_n, overwrite = TRUE)
genepop_to_genind(path = file_n, n.loci = 20,
                  pop_names = as.character(order(as.character(1:10))))
file.remove(file_n)
}
\references{
\insertRef{raymond1995genepop}{graph4lg}
}
\seealso{
For more details about GENEPOP file formatting :
\url{http://genepop.curtin.edu.au/help_input.html#Input}
For the opposite conversion, see \code{\link{genind_to_genepop}}.
The output file can be used to compute pairwise FST matrix
with \code{\link{mat_pw_fst}}
}
\author{
P. Savary
}
