% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{par2Matrix}
\alias{par2Matrix}
\alias{par2Gamma}
\alias{par2Theta}
\title{Create Gamma or Theta from vector}
\usage{
par2Matrix(par, allowMatrix = FALSE, allowNull = FALSE, zeroRowSums = FALSE)

par2Gamma(par, allowMatrix = FALSE, allowNull = FALSE)

par2Theta(par, allowMatrix = FALSE, allowNull = FALSE)
}
\arguments{
\item{par}{Numeric vector with \code{d} elements.
Upper triangular part of a Gamma/Theta matrix.}

\item{allowMatrix}{If \code{TRUE} and \code{par} is already a matrix, return it as is.}

\item{allowNull}{If \code{TRUE} and \code{par} is NULL, return NULL.}

\item{zeroRowSums}{If \code{TRUE} the diagonal is set to (-1) times the rowSums.}
}
\value{
Numeric matrix \dxd. Full Gamma/Theta matrix.
}
\description{
This function takes the parameters in the vector \code{par}
(upper triangular Gamma/Theta matrix) and returns the full Gamma/Theta.
}
\keyword{internal}
