% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_stress.R
\name{layout_stress3D}
\alias{layout_stress3D}
\alias{layout_with_stress3D}
\title{stress majorization layout in 3D}
\usage{
layout_with_stress3D(
  g,
  weights = NA,
  iter = 500,
  tol = 1e-04,
  mds = TRUE,
  bbox = 30
)
}
\arguments{
\item{g}{igraph object}

\item{weights}{possibly a numeric vector with edge weights. If this is NULL and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute). By default, weights are ignored. See details for more.}

\item{iter}{number of iterations during stress optimization}

\item{tol}{stopping criterion for stress optimization}

\item{mds}{should an MDS layout be used as initial layout (default: TRUE)}

\item{bbox}{width of layout. Only relevant to determine the placement of disconnected graphs}
}
\value{
matrix of xyz coordinates
}
\description{
force-directed graph layout based on stress majorization in 3D.
}
\details{
Be careful when using weights. In most cases, the inverse of the edge weights should be used to ensure that the endpoints of an edges with higher weights are closer together (weights=1/E(g)$weight).
}
\references{
Gansner, E. R., Koren, Y., & North, S. (2004). Graph drawing by stress majorization. \emph{In International Symposium on Graph Drawing} (pp. 239-250). Springer, Berlin, Heidelberg.
}
\seealso{
\link{layout_stress}
}
