% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_yr.R
\name{as_yr}
\alias{as_yr}
\alias{as_yr.default}
\alias{as_yr.yr}
\alias{as_yr.yrmon}
\alias{as_yr.yrqtr}
\alias{as_yr.Date}
\alias{as_yr.POSIXt}
\alias{as_yr.character}
\alias{as_yr.factor}
\title{Convert an object to a yr}
\usage{
as_yr(x, ...)

\method{as_yr}{default}(x, ...)

\method{as_yr}{yr}(x, ...)

\method{as_yr}{yrmon}(x, ...)

\method{as_yr}{yrqtr}(x, ...)

\method{as_yr}{Date}(x, ...)

\method{as_yr}{POSIXt}(x, ...)

\method{as_yr}{character}(x, ...)

\method{as_yr}{factor}(x, ...)
}
\arguments{
\item{x}{`An object to coerce to yr.}

\item{...}{Not used.}
}
\value{
A \code{yr} object.
}
\description{
\itemize{
\item Date, POSIXct, and POSIXlt are converted directly.  Any day, hour, minute,
or second components are dropped. POSIXct and POSIXlt are converted to
dates via \code{as.date()} with the timezone respected.
\item Character input is assumed to be provided in either ISO 8601 standard
format, i.e. "yyyy-mm-dd".
}
}
\examples{
as_yr(Sys.Date())
as_yr(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))
as_yr("2019-05-03")

}
