% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_yrmon.R
\name{as_yrmon}
\alias{as_yrmon}
\alias{as_yrmon.default}
\alias{as_yrmon.yrmon}
\alias{as_yrmon.Date}
\alias{as_yrmon.POSIXlt}
\alias{as_yrmon.POSIXct}
\alias{as_yrmon.character}
\alias{as_yrmon.factor}
\title{Convert an object to a yrmon}
\usage{
as_yrmon(x, ...)

\method{as_yrmon}{default}(x, ...)

\method{as_yrmon}{yrmon}(x, ...)

\method{as_yrmon}{Date}(x, ...)

\method{as_yrmon}{POSIXlt}(x, ...)

\method{as_yrmon}{POSIXct}(x, ...)

\method{as_yrmon}{character}(x, ...)

\method{as_yrmon}{factor}(x, ...)
}
\arguments{
\item{x}{`An object to coerce to yrmon.}

\item{...}{Not used.}
}
\value{
A \code{yrmon} object.
}
\description{
\itemize{
\item Date, POSIXct, and POSIXlt are converted directly.  Any day, hour, minute,
or second components are dropped. POSIXct and POSIXlt are converted to
dates via \code{as.date()} with the timezone respected.
\item Character input is assumed to be provided in either ISO 8601 standard
format, i.e. "yyyy-mm-dd".
}
}
\note{
Internally \code{yrmon} objects are stored as the number of months
(starting at 0) since the Unix Epoch (1970-01-01).
}
\examples{
as_yrmon(Sys.Date())
as_yrmon(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))
as_yrmon("2019-05-03")

}
\references{
The algorithm to convert between dates and yrmon, comes from the
work of Davis Vaughan in the unreleased
\href{https://github.com/DavisVaughan/datea/}{datea} package.
}
