% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearweek.R
\name{as_yearweek}
\alias{as_yearweek}
\alias{as_yearweek.default}
\alias{as_yearweek.Date}
\alias{as_yearweek.POSIXt}
\alias{as_yearweek.character}
\alias{as_yearweek.factor}
\title{Coerce to a yearweek object}
\usage{
as_yearweek(x, ...)

\method{as_yearweek}{default}(x, ...)

\method{as_yearweek}{Date}(x, firstday = 1L, ...)

\method{as_yearweek}{POSIXt}(x, firstday = 1L, ...)

\method{as_yearweek}{character}(
  x,
  firstday = 1L,
  format,
  tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"),
  ...
)

\method{as_yearweek}{factor}(
  x,
  firstday = 1L,
  format,
  tryFormats = c("\%Y-\%m-\%d", "\%Y/\%m/\%d"),
  ...
)
}
\arguments{
\item{x}{\R object.}

\item{...}{Other values passed to as.Date().}

\item{firstday}{\verb{[integer]}

The day the week starts on from 1 (Monday) to 7 (Sunday).}

\item{format}{\verb{[character]}

Passed to as.Date() unless \code{format = "yearweek"} in which case input is
assumed to be in the form "YYYY-Wxx".

If not specified, it will try tryFormats one by one on the first non-NA
element, and give an error if none works. Otherwise, the processing is via
\code{strptime()} whose help page describes available conversion specifications.}

\item{tryFormats}{\verb{[character]}

Format strings to try if format is not specified.}
}
\value{
A \verb{<grates_yearweek>} object.
}
\description{
Generic for conversion to <grates_yearweek>.
}
\details{
\itemize{
\item Date, POSIXct, and POSIXlt are converted with the timezone respected.
\item Character objects are first coerced to date via \code{as.Date()} unless
\code{format = "yearweek"} in which case input is assumed to be in the form
"YYYY-Wxx" and parsed accordingly.
}
}
\examples{
as_yearweek(Sys.Date())
as_yearweek(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"))
as_yearweek("2019-05-03", firstday = 5L)
as_yearweek("2019-W12", format = "yearweek")

}
\seealso{
\code{as.Date()} and \code{new_yearweek()}.
}
