% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gjrm-methods.R
\name{draw.gamlss}
\alias{draw.gamlss}
\title{Plot smooths of a GAMLSS model estimated by \code{GJRM::gamlss}}
\usage{
\method{draw}{gamlss}(
  object,
  scales = c("free", "fixed"),
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  widths = NULL,
  heights = NULL,
  ...
)
}
\arguments{
\item{object}{a model, fitted by \code{\link[GJRM:gamlss]{GJRM::gamlss()}}}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? If \code{scales = "free"}, the default, each univariate
smooth has its own y-axis scale. If \code{scales = "fixed"}, a common y axis
scale is used for all univariate smooths.

Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{widths, heights}{The relative widths and heights of each column and
row in the grid. Will get repeated to match the dimensions of the grid. If
there is more than 1 plot and \code{widths = NULL}, the value of \code{widths} will
be set internally to \code{widths = 1} to accommodate plots of smooths that
use a fixed aspect ratio.}

\item{...}{arguments passed to \code{\link[=draw.gam]{draw.gam()}}}
}
\description{
Provides a \code{\link[=draw]{draw()}} method for GAMLSS (distributional GAMs) fitted
by \code{\link[GJRM:gamlss]{GJRM::gamlss()}}.
}
\note{
Plots of smooths are not labelled with the linear predictor to which
they belong.
}
\examples{
if (suppressPackageStartupMessages(require("GJRM", quietly = TRUE))) {
  # follow example from ?GJRM::gamlss
  load_mgcv()
  suppressPackageStartupMessages(library("GJRM"))
  set.seed(0)
  n <- 100
  x1 <- round(runif(n))
  x2 <- runif(n)
  x3 <- runif(n)
  f1 <- function(x) cos(pi * 2 * x) + sin(pi * x)
  y1 <- -1.55 + 2 * x1 + f1(x2) + rnorm(n)
  dataSim <- data.frame(y1, x1, x2, x3)

  eq_mu <- y1 ~ x1 + s(x2)
  eq_s <- ~ s(x3, k = 6)
  fl <- list(eq_mu, eq_s)
  m <- gamlss(fl, data = dataSim)

  draw(m)
}
}
