% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edf.R
\name{edf}
\alias{edf}
\alias{edf.gam}
\alias{model_edf}
\title{Effective degrees of freedom for smooths and GAMs}
\usage{
edf(object, ...)

\method{edf}{gam}(
  object,
  select = NULL,
  smooth = deprecated(),
  type = c("default", "unconditional", "alternative"),
  partial_match = FALSE,
  ...
)

model_edf(object, ..., type = c("default", "unconditional", "alternative"))
}
\arguments{
\item{object}{a fitted model from which to extract smooth-specific EDFs.}

\item{...}{arguments passed to methods.}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn. Numeric \code{select}
indexes the smooths in the order they are specified in the formula and
stored in \code{object}. Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{smooth}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{select} instead.
extracted. If \code{NULL}, the default, EDFs for all smooths will be returned.}

\item{type}{character: which type of EDF to return. \code{"default"} returns the
standard EDF; \code{"unconditional"} selects the EDF corrected for smoothness
parameter selection, if available; \code{"alternative"} returns the alternative
formulation for EDF from Wood (2017, pp. 252)}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{select}? If \code{TRUE}, \code{select} can only be a single string to match
against.}
}
\description{
Extracts the effective degrees of freedom (EDF) for model smooth terms or
overall EDF for fitted GAMs
}
\details{
Multiple formulations for the effective degrees of freedom are
available. The additional uncertainty due to selection of smoothness
parameters can be taken into account when computing the EDF of smooths.
This form of the EDF is available with \code{type = "unconditional"}.

Wood (2017; pp. 252) describes an alternative EDF for the  model
\deqn{\mathrm{EDF} = 2\mathrm{tr}(\mathbf{F}) -
  \mathrm{tr}(\mathbf{FF}),}{EDF = 2 * tr(F) - tr(F),} where
\eqn{\mathrm{tr}} is the matrix trace and \eqn{\mathbf{F}}{F} is a matrix
mapping un-penalized coefficient estimates to the penalized coefficient
estimates.  The trace of \eqn{\mathbf{F}}{F} is effectively the average
shrinkage of the coefficients multipled by the number of coefficients
(Wood, 2017). Smooth-specific EDFs then are obtained by summing up the
relevent elements of \eqn{\mathrm{diag}(2\mathbf{F} - \mathbf{FF})}.
}
\examples{
load_mgcv()
\dontshow{
op <- options(cli.unicode = FALSE, pillar.sigfig = 5)
}
df <- data_sim("eg1", n = 400, seed = 42)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

# extract the EDFs for all smooths
edf(m)

# or selected smooths
edf(m, select = c("s(x0)", "s(x2)"))

# accounting for smoothness parameter uncertainty
edf(m, type = "unconditional")

# over EDF of the model, including the intercept
model_edf(m)

# can get model EDF for multiple models
m2 <- gam(y ~ s(x0) + s(x1) + s(x3), data = df, method = "REML")
model_edf(m, m2)
\dontshow{
options(op)
}
}
