% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newstart_allowance.R
\name{newstart_allowance}
\alias{newstart_allowance}
\title{Newstart allowance}
\source{
\url{http://classic.austlii.edu.au/au/legis/cth/consol_act/ssa1991186/s1068.html}
}
\usage{
newstart_allowance(fortnightly_income = 0, annual_income = 0,
  has_partner = FALSE, partner_pensioner = FALSE, n_dependants = 0,
  nine_months = FALSE, isjspceoalfofcoahodeoc = FALSE,
  principal_carer = FALSE, fortnightly_partner_income = 0,
  annual_partner_income = 0, age = 22, fy.year = "2015-16",
  assets_value = 0, homeowner = FALSE, lower = 102, upper = 252,
  taper_lower = 0.5, taper_upper = 0.6, taper_principal_carer = 0.4,
  per = c("year", "fortnight"))
}
\arguments{
\item{fortnightly_income}{'Ordinary income' received fortnightly within the 
meaning of s. 1068-G1 of the \emph{Social Security Act 1991}.}

\item{annual_income}{'Ordinary income' received annually.}

\item{has_partner}{Does the individual have a partner?}

\item{partner_pensioner}{Does the partner receive a pension?}

\item{n_dependants}{How many dependant children does the individual have?}

\item{nine_months}{If the person is over 60 years old, have they been 
receiving payments for over 9 continuous months?}

\item{isjspceoalfofcoahodeoc}{Is the recipient a single job seeker principal carer, either of large family or foster child/ren, or who is a home or distance educator of child/ren?}

\item{principal_carer}{Is the individual the parent with most of the day-to-day
care of child. Defined in \url{https://www.humanservices.gov.au/individuals/enablers/principal-carer-rules-parenting-payment/41456}.}

\item{fortnightly_partner_income}{Partner's 'Ordinary income' received fortnightly.}

\item{annual_partner_income}{Partner's Ordinary income' received annually.}

\item{age}{The individual's age.}

\item{fy.year}{Financial year. Default is "2015-16".}

\item{assets_value}{Total value of household assets. Details can be found at
\url{https://www.humanservices.gov.au/individuals/enablers/assets/30621}.}

\item{homeowner}{Is the individual a homeowner?}

\item{lower}{Lower bound for which reduction in payment occurs at rate 
\code{taper_lower} (\code{taper_principal_carer} for principal carers).}

\item{upper}{Upper bound for which reduction in payment occurs at rate 
\code{taper_lower}. Lower bound for which reduction in payment occurs at rate
\code{taper_upper}. Note that for principal carers there is no upper bound.}

\item{taper_lower}{The amount at which the payment is reduced for each dollar
earned between the lower and upper bounds for non-principal carers.}

\item{taper_upper}{The amount at which the payment is reduced for each dollar
earned above the upper bound for non-principal carers.}

\item{taper_principal_carer}{The amount at which the payment is reduced for
each dollar earned above the lower bound for principal carers.}

\item{per}{Specifies the timeframe in which payments will be made. 
Can either take value "fortnight" or "annual".}
}
\description{
Newstart allowance
}
