% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/income_tax_sapto.R
\name{income_tax_sapto}
\alias{income_tax_sapto}
\title{Income tax payable as a function of SAPTO}
\usage{
income_tax_sapto(income, fy.year = NULL, age = 42,
  family_status = "individual", n_dependants = 0L,
  return.mode = c("numeric", "integer"), .dots.ATO = NULL,
  allow.forecasts = FALSE, sapto.eligible, medicare.sapto.eligible,
  new_sapto_tbl = NULL)
}
\arguments{
\item{income}{The individual assessable income.}

\item{fy.year}{The financial year in which the income was earned. Only tax years from 2000-01 to 2016-17 are available. If fy.year is not given, the current financial year is used by default.}

\item{age}{The individual's age.}

\item{family_status}{For Medicare and SAPTO purposes.}

\item{n_dependants}{An integer for the number of children of the taxpayer (for the purposes of the Medicare levy).}

\item{return.mode}{The mode (numeric or integer) of the returned vector.}

\item{.dots.ATO}{A data.frame that contains additional information about the individual's circumstances, with columns the same as in the ATO sample files. If \code{.dots.ATO} is a \code{data.table}, I recommend you enclose it with \code{copy()}.}

\item{allow.forecasts}{should dates beyond 2016-17 be permitted? Currently, not permitted.}

\item{sapto.eligible}{Specify explicitly the eligibility for SAPTO. If missing, defaults to ages over 65.}

\item{medicare.sapto.eligible}{Specify explicitly the eligibility for SAPTO with respect to the Medicare levy for low-income earners. If missing, defaults to ages over 65.}

\item{new_sapto_tbl}{If not \code{NULL}, supplied to \code{\link{new_sapto}}. Otherwise, \code{fy.year} is passed to \code{\link{sapto}}.}
}
\description{
Income tax payable as a function of SAPTO
}
\details{
Used to cost simple changes to SAPTO.
}
