% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Greeks.R
\name{Greeks}
\alias{Greeks}
\title{Computes the greeks of vaious options}
\usage{
Greeks(
  initial_price,
  exercise_price,
  r,
  time_to_maturity,
  volatility,
  dividend_yield = 0,
  model = "Black_Scholes",
  option_type = "European",
  payoff = "call",
  greek = c("fair_value", "delta", "vega", "theta", "rho", "gamma")
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset
}}

\item{exercise_price}{\itemize{
\item strike price of the option
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{model}{\itemize{
\item the model to be chosen
}}

\item{option_type}{in c("European", "American", "Asian", "Digital") - the
type of option to be considered}

\item{payoff}{\itemize{
\item in c("call", "put")
}}

\item{greek}{\itemize{
\item greeks to be calculated in c("fair_value", "delta", "vega",
"theta", "rho", "epsilon", "lambda", "gamma", "vanna")
}}
}
\value{
Named vector containing the values of the greeks specified in the
parameter \code{greek}.
}
\description{
Computes the greeks of vaious options
}
\examples{
BS_European_Greeks(initial_price = 120, exercise_price = 100,
r = 0.02, time_to_maturity = 4.5, dividend_yield = 0.015, volatility = 0.22,
greek = c("fair_value", "delta", "gamma"), payoff = "put")
}
