% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessibility_mapbox.R
\name{accessibility_mapbox}
\alias{accessibility_mapbox}
\title{Create a dynamic Accessibility Map Using Mapbox GL JS}
\usage{
accessibility_mapbox(
  green_area_data,
  mapbox_token,
  output_file = "accessibility_map.html",
  initial_zoom = 15,
  initial_pitch = 45,
  initial_bearing = -17.6
)
}
\arguments{
\item{green_area_data}{A list containing green area data.}

\item{mapbox_token}{Character, your Mapbox access token.}

\item{output_file}{Character, the file path to save the HTML file.}

\item{initial_zoom}{Numeric, the initial zoom level of the map. Default is 15.}

\item{initial_pitch}{Numeric, the initial pitch of the map. Default is 45.}

\item{initial_bearing}{Numeric, the initial bearing of the map. Default is -17.6.}
}
\value{
NULL. The function creates an HTML file and opens it in the viewer or browser if run interactively.
}
\description{
This function creates a dynamic accessibility map using Mapbox GL JS. The map shows green areas and allows users to generate isochrones for walking times.
}
\examples{
if (interactive()) {
  data <- get_osm_data("Basel, Switzerland")
  green_areas_data <- data$green_areas
  mapbox_token <- "your_mapbox_access_token_here"
  accessibility_mapbox(green_areas_data, mapbox_token)
}
}
