% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_tex.R
\name{include_tex}
\alias{include_tex}
\title{Include TeX file in R Markdown or Quarto document.}
\usage{
include_tex(chunk="",tex="",path=".",start=NA,end=NA)
}
\arguments{
\item{chunk}{Name of the \code{gretl} chunk that generates the \code{TeX} file.}

\item{tex}{Name of a \code{LaTeX} file}

\item{path}{Object or a character string representing the path(s) to the \code{TeX} (default: \code{"."})}

\item{start}{Numeric. The start line of the \code{TeX} file to include.}

\item{end}{Numeric. The last line of the \code{TeX} file to include.}
}
\value{
Set of \code{gretl} (open-source software for Econometrics) outputs
}
\description{
Use this function to include TeX file in R Markdown or Quarto document.
}
\examples{
library(gretlR)
\dontrun{
include_tex(chunk="gretlR1",tex="ols")

include_tex("path/to/the/tex/file.tex")
}
}
\seealso{
Other important functions: 
\code{\link{eng_gretl}()},
\code{\link{exec_gretl}()},
\code{\link{exec_inp}()},
\code{\link{gretlR}},
\code{\link{import_kable}()},
\code{\link{include_graph}()},
\code{\link{write_inp}()}
}
\concept{important functions}
\keyword{documentation}
