% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greybox-package.R
\docType{package}
\name{greybox}
\alias{greybox}
\alias{greybox-package}
\title{Grey box}
\description{
Toolbox for working with multivariate models for purposes of analysis and forecasting
}
\details{
\tabular{ll}{ Package: \tab greybox\cr Type: \tab Package\cr Date: \tab
2018-02-13 - Inf\cr License: \tab GPL-2 \cr } The following functions are
included in the package:
\itemize{
\item \link[greybox]{AICc} and \link[greybox]{BICc} - AIC / BIC corrected for the
sample size.
\item \link[greybox]{determination} - Coefficients of determination between different
exogenous variables.
\item \link[greybox]{stepwise} - Stepwise based on information criteria and partial
correlations. Efficient and fast.
\item \link[greybox]{xregExpander} - Function that expands the provided data into
the data with lags and leads.
\item \link[greybox]{lmCombine} - Function combines lm models from the estimated
based on information criteria weights.
\item \link[greybox]{ro} - Rolling origin evaluation.
\item \link[greybox]{qlaplace}, \link[greybox]{dlaplace},
\link[greybox]{plaplace}, \link[greybox]{rlaplace} - Laplace distribution and the
respective functions.
\item \link[greybox]{qs}, \link[greybox]{ds}, \link[greybox]{ps},
\link[greybox]{rs} - S distribution and the respective functions.
}
}
\examples{

\dontrun{
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

stepwise(xreg)
}

}
\seealso{
\code{\link[greybox]{stepwise}, \link[greybox]{lmCombine}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}

Maintainer: Ivan Svetunkov
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
