% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_tools.R
\name{get_tree}
\alias{get_tree}
\title{Retrieve a single tree from a trained forest object.}
\usage{
get_tree(forest, index)
}
\arguments{
\item{forest}{The trained forest.}

\item{index}{The index of the tree to retrieve.}
}
\value{
A GRF tree object.
}
\description{
Retrieve a single tree from a trained forest object.
}
\examples{
# Train a quantile forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
q.forest = quantile_forest(X, Y, quantiles=c(0.1, 0.5, 0.9))

# Examine a particular tree.
q.tree = get_tree(q.forest, 3)
q.tree$nodes

}
