% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_costmat.R
\name{transport_costmat}
\alias{transport_costmat}
\alias{transport_costmat.otgrid}
\alias{transport_costmat.otgridtransport}
\title{Cost Matrix for two-dimensional Optimal Transport}
\usage{
transport_costmat(x, ...)

\method{transport_costmat}{otgrid}(x, y, p.1 = 2, p.2 = p.1, ...)

\method{transport_costmat}{otgridtransport}(x, ...)
}
\arguments{
\item{x}{an object of class \code{"otgridtransport"} or \code{"otgrid"}, in the latter case it gives the object the mass is to be transported from.}

\item{...}{further arguments (currently unused).}

\item{y}{an object of class \code{"otgrid"} the mass is to be transported from.}

\item{p.1}{the first power \eqn{\geq 1} of the cost.}

\item{p.2}{the second power \eqn{\geq 1} of the cost.}
}
\value{
a matrix giving the pairwise costs in column-mayor format.
}
\description{
Calculate the cost matrix for the optimal transport between two-dimensional grids with respect to the cost function
\deqn{c(x, y) = | x_1 - y_1 |^{p_1} + | x_2 - y_2 |^{p_2}.}
}
\examples{
x <- otgrid(cbind(0:1, 1:0))
y <- otgrid(cbind(1:0, 0:1))

transport_costmat(x, y, p.1 = 1, p.2 = 3)
}
