% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-geometry-fill.R
\name{grid.pattern_fill}
\alias{grid.pattern_fill}
\title{Grobs with a simple fill pattern}
\usage{
grid.pattern_fill(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  fill = gp$fill \%||\% "grey80",
  alpha = gp$alpha \%||\% NA_real_,
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{fill}{Fill colour(s) or \code{\link[grid:patterns]{grid::pattern()}} / gradient object(s).}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_fill()} draws a simple fill pattern onto the graphics device.
}
\examples{
x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
grid.pattern_fill(x_hex, y_hex, fill = "blue")

if (guess_has_R4.1_features("patterns")) {
  grid::grid.newpage()
  stripe_fill <- patternFill("stripe", fill = c("red", "blue"))
  grid.pattern_fill(x_hex, y_hex, fill = stripe_fill)
}
}
\seealso{
\code{\link[grid:grid.polygon]{grid::grid.polygon()}}
}
