% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_cm_per_click.R
\name{sample_cm_per_click}
\alias{sample_cm_per_click}
\title{Sample CM Per Click}
\usage{
sample_cm_per_click(input_df, priors, n_samples = 50000)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str), sum_conversions (dbl), sum_revenue (dbl),
and sum_clicks (dbl).}

\item{priors}{Optional list of priors {alpha0, beta0} for Beta, {k0, theta0} for Gamma Inverse Revenue,
and {k01, theta01} for Gamma Cost (uses alternate priors so they can be different from Revenue).
Default \eqn{Beta(1,1)} and \eqn{Gamma(1, 250)} will be use otherwise.}

\item{n_samples}{Optional integer value. Defaults to 50,000 samples.}
}
\value{
input_df with 4 new nested columns `beta_params`, `gamma_params_rev`,
    `gamma_params_cost`, and `samples`
}
\description{
Adds 4 new nested columns to the input_df: `beta_params`,
    `gamma_params_rev`, `gamma_params_cost`and `samples`
}
\details{
`beta_params` and `gamma_params_rev` in each row should be a
tibble of length 2 (\eqn{\alpha} and \eqn{\beta} parameters
and \eqn{k} and \eqn{\theta} parameters)
`samples` in each row should be a tibble of length `n_samples`

See update_rules vignette for a mathematical representation.
\deqn{CMPerClick = ConversionsPerClick * RevPerConversion - CostPerClick}
}
