\name{drBootSpline}
\Rdversion{1.1}
\alias{drBootSpline}
\title{
Function to create a bootstrap sample of splines fitted to dose-response curves.
}
\description{
The function passes the numeric vectors \code{conc} and \code{test} to the function \link{drFitSpline}, which fits a smoothed spline to the data and estimates the EC50. Calling \link{drFitSpline} several times (specified by the options set in \code{control}) creates a bootstrap sample in form of a list of objects of class \code{drFitSpline}.
}
\usage{
drBootSpline(conc, test, drID = "undefined", 
             control = grofit.control())
}
\arguments{
  \item{conc}{
Numeric vector, containing concentration information for dose-response. curve fit and EC50 estimation.
}
  \item{test}{
Numeric vector, containing response values related to concentrations.
}
  \item{drID}{
Character, identifying the dose-response data.
}
  \item{control}{
Object of class \code{grofit.control} containing a list of options generated by the function \code{\link{grofit.control}}.
}
}
\value{
Generates an object of class \code{drBootSpline}
\item{raw.conc}{Raw data given to the function; equivalent to \code{conc}.}
\item{raw.test}{Raw data given to the function; equivalent to \code{test}.}
\item{drID}{String identifier given to the function; equivalent to \code{drID}.}
\item{boot.conc}{Table of concentration values per column, resulting from each spline fit of the bootstrap.}
\item{boot.test}{Table of response values per column, resulting from each spline fit of the bootstrap.}
\item{boot.drSpline}{List containing all \code{drFitSpline} objects generated by the call of \link{drFitSpline}.}
\item{ec50.boot}{Vector of estimated EC50 values from each bootstrap entry.}
\item{bootFlag}{Logical, indicating an empty bootstrap sample.}
\item{control}{Object of class \code{grofit.control} containing list of options passed to the function as \code{control}.}
}
\examples{
x <- 1:50
y <- 30/(1+exp(-0.5*(25-x)))+rnorm(50)
TestRun <- drBootSpline(x,y,"ID",grofit.control(nboot.dr=50))
print(summary(TestRun))
plot(TestRun)
}
\seealso{
\code{\link{drFitSpline}}, \code{\link{summary.drBootSpline}}, \code{\link{plot.drBootSpline}} 
}
