% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.conflict.R
\name{reinstall.conflicts}
\alias{reinstall.conflicts}
\title{Re-install packages that created a conflict}
\usage{
reinstall.conflicts(since = "1970-01-01")
}
\arguments{
\item{since}{(optional) character string  (yyyy-mm-dd), or date value, to specify that only packages uninstalled
since that date will be reinstalled. If not set then all packages ever uninstalled this way will be re-installed.}
}
\description{
Re-install uninstalled packages (from the non-groundhog local library) previously uninstalled to prevent
conflict with installation via groundhog.library()
}
\details{
When installing packages with groundhog.library(), if another version of a needed package or dependency
is already loaded the process ends. This is usually solved by restarting the R session thus unloading the conflicting package.
But on occasion the problem persists, often because R Studio loads the undesired version of the package automatically from
the local (non-groundhog) library. When this occurs, groundhog.library() will prompt users with a set of options, one of which is
to  uninstall these packages from the non-groundhog library.
The set of packages uninstalled in this way are recorded and saved to a data.frame, allowing easily undoing this action,
even months later. Specifically, a user running the function \code{reinstalled.conflicts()} will loop over that data.frame,
reinstalling all packages listed if they are not currently available (into the original path they were previously installed).
Again, these are not packages in the groundhog library, but rather, in the default library R uses to install packages.
IF the optiona parameter \code{since} is used, only packages uninstalled since that date will be reinstalled.
}
\note{
Because these packages are not managed by groundhog, there is no version control. The package that is re-installed
may be a newer version than that previously available (or the installation may fail if the package becomes archived).
}
\examples{
\dontrun{
#Re-install all packages ever uninstalled due to conflict
reinstall.conflicts()
#Re-install all packages uninstalled since 2021-02-04 due to conflict
reinstall.conflicts("2021-02-04")
}

}
