% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_baranyi.R
\name{grow_baranyi}
\alias{grow_baranyi}
\title{The Baranyi and Roberts Growth Model}
\usage{
grow_baranyi(time, parms)
}
\arguments{
\item{time}{vector of time steps (independent variable).}

\item{parms}{named parameter vector of the Baranyi growth model with:
\itemize{
  \item \code{y0} initial value of abundance,
  \item \code{mumax} maximum growth rate (1/time),
  \item \code{K} carrying capacity (max. abundance),
  \item \code{h0} parameter specifying the initial physiological state of
    organisms (e.g. cells) and in consequence the lag phase
    (h0 = max growth rate * lag phase).
}}
}
\value{
vector of dependent variable (\code{y}) and its log-transformed
  values (\code{log_y}).
}
\description{
The growth model of Baranyi and Roberts (1995) written as analytical solution
of the system of differential equations.
}
\details{
The version of the equation used in this package has the following form:

\deqn{A = time + 1/mumax * log(exp(-mumax * time) + exp(-h0) - exp(-mumax * time - h0))}
\deqn{log(y) = log(y0) + mumax * A - log(1 + (exp(mumax * A) - 1) / exp(log(K) - log(y0)))}
}
\examples{

time <- seq(0, 30, length=200)
y    <- grow_baranyi(time, c(y0=0.01, mumax=.5, K=0.1, h0=5))[,"y"]
plot(time, y, type="l")
plot(time, y, type="l", log="y")

}
\references{
Baranyi, J. and Roberts, T. A. (1994).
A dynamic approach to predicting bacterial growth in food.
International Journal of Food Microbiology, 23, 277-294.

Baranyi, J. and Roberts, T.A. (1995). Mathematics of predictive microbiology.
International Journal of Food Microbiology, 26, 199-218.
}
\seealso{
Other growth models: \code{\link{grow_exponential}},
  \code{\link{grow_gompertz}}, \code{\link{grow_huang}},
  \code{\link{grow_logistic}}, \code{\link{grow_richards}},
  \code{\link{growthmodel}}, \code{\link{ode_genlogistic}},
  \code{\link{ode_twostep}}
}
