## function: cross-validation for survival
# ------------------------------------------------------------------------------
cv.grpsurvOverlap <- function(X, y, group, ..., nfolds=10, seed, 
                              cv.ind, returnY = FALSE,
                              trace=FALSE) {
  fit <- grpregOverlap(X=X, y=y, group=group, returnX = TRUE, 
                       family = 'cox', ...)
  cvfit <- cv.grpsurv(X = fit$X.latent, y = y, group = fit$grp.vec, ...,
                     nfolds = nfolds, seed = seed, 
                     cv.ind = cv.ind, returnY = returnY,
                     trace = trace)
  cvfit$fit <- fit
  val <- structure(cvfit, class = c('cv.grpregOverlap', 'cv.grpsurv', 'cv.grpreg'))
  val
}
# ------------------------------------------------------------------------------
