% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsdensity_functions.R
\name{run.rwr.list}
\alias{run.rwr.list}
\title{result in a matrix (number of rows = number of cells; number of columns = number of gene sets)
reflecting the probability each cell is labeled during the
propagation (relevance to the gene set); same idea as run.rwr but with multiple
gene sets}
\usage{
run.rwr.list(el, gene_set_list, cells, restart = 0.75)
}
\arguments{
\item{el}{edge list; output of 'compute.nn.edges'}

\item{gene_set_list}{a list of gene sets}

\item{cells}{name of cells; usually the same as 'colnames(object)'}

\item{restart}{the probability of the propagation to restart}
}
\value{
activity of pathways in cells
}
\description{
result in a matrix (number of rows = number of cells; number of columns = number of gene sets)
reflecting the probability each cell is labeled during the
propagation (relevance to the gene set); same idea as run.rwr but with multiple
gene sets
}
\examples{
\donttest{
cells <- colnames(pbmc.mtx)
el <- gsdensity::compute.nn.edges(coembed = ce, nn.use = 300)
cv <- run.rwr.list(el = el, gene_set = gene.set.list[1:3], cells = cells)
}
}
