% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dftmtx.R
\name{dftmtx}
\alias{dftmtx}
\title{Discrete Fourier Transform Matrix}
\usage{
dftmtx(n)
}
\arguments{
\item{n}{Size of Fourier transformation matrix, specified as a positive
integer.}
}
\value{
Fourier transform matrix.
}
\description{
Compute the discrete Fourier transform matrix
}
\details{
A discrete Fourier transform matrix is a complex matrix whose matrix product
with a vector computes the discrete Fourier transform of the vector.
\code{dftmtx} takes the FFT of the identity matrix to generate the transform
matrix. For a column vector \code{x}, \code{y <- dftmtx(n) * x} is the same
as \code{y <- fft(x, postpad(x, n)}. The inverse discrete Fourier transform
matrix is \code{inv <- Conj(dftmtx(n)) / n}.

In general this is less efficient than calling the \code{fft} and \code{ifft}
functions directly.
}
\examples{
x <- seq_len(256)
y1 <- stats::fft(x)
n <- length(x)
y2 <- drop(x \%*\% dftmtx(n))
mx <- max(abs(y1 - y2))

}
\seealso{
\code{\link[stats]{fft}}, \code{\link{ifft}}
}
\author{
David Bateman, \email{adb014@gmail.com}.\cr Conversion to R by Geert
  van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
