% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polystab.R
\name{polystab}
\alias{polystab}
\title{Stabilize polynomial}
\usage{
polystab(a)
}
\arguments{
\item{a}{vector of polynomial coefficients, normally in the z-domain}
}
\value{
Vector of stabilized polynomial coefficients.
}
\description{
Stabilize the polynomial transfer function by replacing all roots outside the
unit circle with their reflection inside the unit circle.
}
\examples{
unstable <- c(-0.5, 1)
zplane(unstable, 1)
stable <- polystab(unstable)
zplane(stable, 1)

}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr Conversion to R by
  Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
