% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cnv}
\alias{plot_cnv}
\title{Plot Copy Number Variations}
\usage{
plot_cnv(dat, lwd = 1, col = grDevices::rgb(0, 0, 0, 0.5), x.cex = 1,
  y.cex = 1, ...)
}
\arguments{
\item{dat}{List object, containing vectors samples, pos and chr and matrix cnv.}

\item{lwd}{Line width for raster.}

\item{col}{Color of raster lines.}

\item{x.cex}{Character size in x-axis.}

\item{y.cex}{Character size in y-axis.}

\item{...}{are forwarded to the image() command.}
}
\description{
Plots copy number variations in a grid to allow for comparisons between individuals.
Deletions and duplications are represented in red and green, respectively.
}
\examples{
\dontrun{
if(require(brassicaData)){
data(raw_napus, package = "brassicaData", envir = environment())
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:100)][-(30000:30100)])
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
dat <- cnv(dat, dup = 0.03, del = -0.06)
plot_cnv(dat)
}
}
}

