% Generated by roxygen2 (4.0.1): do not edit by hand
\name{Gst_prime}
\alias{Gst_prime}
\title{Estimation Nei's Gst parameter with Hedrick's correction for allelic diversity}
\usage{
Gst_prime(x, stratum = "Population", nperm = 0, size.correct = TRUE)
}
\arguments{
\item{x}{A vector of \code{\link{locus}} objects or a \code{data.frame} with \code{locus} objects.}

\item{stratum}{Either a vector of strata variables if \code{x} is a \code{locus} vector or
the name of the column representing strata in \code{x} if it is a \code{data.frame}.}

\item{nperm}{The number of permutations to run for significance of the
estimator.}

\item{size.correct}{A flag indicating that the estimate should be corrected for
based upon sample sizes (default=TRUE).}
}
\value{
An \code{data.frame} with Gst, Ht, and Hs and optionally P.  If more than one locus is provided,
 then a 'mutlilocus' estimate is shown using the harmonic mean of individual locus Gst_prime values.
}
\description{
This function estimates the parameter (and potentially the confidence
 surrounding its value) for Gst.  It is corrected by the diversity of the
 parameter as outlined by Hedrick.
}
\examples{
a1 <- sample( LETTERS[1:5], size=20, replace=TRUE)
 a2 <- sample( LETTERS[4:8], size=20, replace=TRUE)
 raw_alleles <- matrix( c(a1,a2), ncol=2, byrow=TRUE )
 locus <- locus( raw_alleles, type="column")
 Population <- c(rep("Pop-A",10),rep("Pop-B",10))
 Gst_prime( locus, Population )
 a1 <- sample( LETTERS[1:5], size=20, replace=TRUE)
 a2 <- sample( LETTERS[4:8], size=20, replace=TRUE)
 raw_alleles <- matrix( c(a1,a2), ncol=2, byrow=TRUE )
 locus2 <- locus( raw_alleles, type="column")
 df <- data.frame( Population, TPI=locus, PGM=locus2 )
 Gst_prime( df, nperm=99)
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

