% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_enthalpy_diff}
\alias{gsw_enthalpy_diff}
\title{Specific Enthalpy Difference with Pressure}
\usage{
gsw_enthalpy_diff(SA, CT, p_shallow, p_deep)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p_shallow}{pressure at a shallower depth [ dbar ]}

\item{p_deep}{pressure at a deeper depth [ dbar ]}
}
\value{
specific enthalpy difference [ J/kg ]
}
\description{
Specific enthalpy difference [ J/kg ].
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(  34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(  28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p_shallow <- c(10,      50,     125,     250,     600,    1000)
p_deep <- c(  110,     150,     225,     350,     700,    1100)
ed <- gsw_enthalpy_diff(SA, CT, p_shallow, p_deep)
expect_equal(ed/1e2, c(9.784180644568052, 9.780195056105020, 9.759587700515114,
                       9.727552719534447, 9.708223170174454, 9.687871289079633))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_enthalpy_diff.html}
}
\seealso{
Other things related to enthalpy: \code{\link{gsw_CT_from_enthalpy}},
  \code{\link{gsw_dynamic_enthalpy}},
  \code{\link{gsw_enthalpy_CT_exact}},
  \code{\link{gsw_enthalpy_first_derivatives_CT_exact}},
  \code{\link{gsw_enthalpy_first_derivatives}},
  \code{\link{gsw_enthalpy_ice}},
  \code{\link{gsw_enthalpy_t_exact}},
  \code{\link{gsw_enthalpy}},
  \code{\link{gsw_frazil_properties_potential_poly}},
  \code{\link{gsw_frazil_properties_potential}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice_poly}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice}},
  \code{\link{gsw_pot_enthalpy_ice_freezing_poly}},
  \code{\link{gsw_pot_enthalpy_ice_freezing}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice_poly}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice}},
  \code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_specvol_first_derivatives}}
}
