% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{define_units}
\alias{define_units}
\title{Define measurement units with \strong{gt}'s units notation}
\usage{
define_units(units_notation)
}
\arguments{
\item{units_notation}{\emph{Text in specialized units notation}

\verb{scalar<character>} // \strong{required}

A single string that defines the units (e.g., \code{"m/s"}) to be used.}
}
\value{
An object of class \code{units_definition}.
}
\description{
The \code{define_units()} function is available for working with text in \strong{gt}'s
units notation.
}
\section{How to use \strong{gt}'s units notation}{


The units notation involves a shorthand of writing units that feels familiar
and is fine-tuned for the task at hand. Each unit is treated as a separate
entity (parentheses and other symbols included) and the addition of subscript
text and exponents is flexible and relatively easy to formulate. This is all
best shown with examples:
\itemize{
\item \code{"m/s"} and \code{"m / s"} both render as \code{"m/s"}
\item \code{"m s^-1"} will appear with the \code{"-1"} exponent intact
\item \code{"m /s"} gives the the same result, as \code{"/<unit>"} is equivalent to
\code{"<unit>^-1"}
\item \code{"E_h"} will render an \code{"E"} with the \code{"h"} subscript
\item \code{"t_i^2.5"} provides a \code{t} with an \code{"i"} subscript and a \code{"2.5"} exponent
\item \code{"m[_0^2]"} will use overstriking to set both scripts vertically
\item \code{"g/L \%C6H12O6\%"} uses a chemical formula (enclosed in a pair of \code{"\%"}
characters) as a unit partial, and the formula will render correctly with
subscripted numbers
\item Common units that are difficult to write using ASCII text may be implicitly
converted to the correct characters (e.g., the \code{"u"} in \code{"ug"}, \code{"um"},
\code{"uL"}, and \code{"umol"} will be converted to the Greek \emph{mu} symbol; \code{"degC"}
and \code{"degF"} will render a degree sign before the temperature unit)
\item We can transform shorthand symbol/unit names enclosed in \code{":"} (e.g.,
\code{":angstrom:"}, \code{":ohm:"}, etc.) into proper symbols
\item Greek letters can added by enclosing the letter name in \code{":"}; you can
use lowercase letters (e.g., \code{":beta:"}, \code{":sigma:"}, etc.) and uppercase
letters too (e.g., \code{":Alpha:"}, \code{":Zeta:"}, etc.)
\item The components of a unit (unit name, subscript, and exponent) can be
fully or partially italicized/emboldened by surrounding text with \code{"*"} or
\code{"**"}
}
}

\section{Function ID}{

8-9
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{stub}()},
\code{\link{system_fonts}()}
}
\concept{helper functions}
