% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_info.R
\name{tab_info}
\alias{tab_info}
\title{Understand what's been set inside of a \strong{gt} table object}
\usage{
tab_info(data)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
It can become increasingly difficult to recall the ID values associated with
different labels in a \strong{gt} table. Further to this, there are also
situations where \strong{gt} will generate ID values on your behalf (e.g., with
\code{\link[=tab_spanner_delim]{tab_spanner_delim()}}, etc.) while ensuring that duplicate ID values aren't
produced. For the latter case, it is impossible to know what those ID values
are unless one were to carefully examine to correct component of the \code{gt_tbl}
object.

Because it's so essential to know these ID values for targeting purposes
(when styling with \code{\link[=tab_style]{tab_style()}}, adding footnote marks with
\code{\link[=tab_footnote]{tab_footnote()}}, etc.), the \code{tab_info()} function can help with all of this.
It summarizes (by location) all of the table's ID values and their associated
labels. The product is an informational \strong{gt} table, designed for easy
retrieval of the necessary values.
}
\section{Examples}{


Let's use a portion of the \code{\link{gtcars}} dataset to create a \strong{gt} table. We'll
use the \code{\link[=tab_spanner]{tab_spanner()}} function to group two columns together under a
spanner column with the ID and label \code{"performance"}. Finally, we can use the
\code{tab_info()} function in a separate, interactive statement so that we can
inspect a table that summarizes the ID values any associated label text for
all parts of the table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl <-
  gtcars |>
  dplyr::select(model, year, starts_with("hp"), msrp) |>
  dplyr::slice(1:4) |>
  gt(rowname_col = "model") |>
  tab_spanner(
    label = "performance",
    columns = starts_with("hp")
  )

gt_tbl |> tab_info()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_info_1.png" alt="This image of a table was generated from the first code example in the `tab_info()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-12
}

\section{Function Introduced}{

\code{v0.8.0} (November 16, 2022)
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_caption}()},
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stub_indent}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style_body}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
