% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cell_fill}
\alias{cell_fill}
\title{Helper for defining custom fills for table cells}
\usage{
cell_fill(color = "#D3D3D3", alpha = NULL)
}
\arguments{
\item{color}{\emph{Cell fill color}

\verb{scalar<character>} // \emph{default:} \code{"#D3D3D3"}

If nothing is provided for \code{color} then \code{"#D3D3D3"} (light gray) will be
used as a default.}

\item{alpha}{\emph{Transparency value}

\verb{scalar<numeric|integer>(0>=val>=1)} // \emph{default:} \code{NULL} (\code{optional})

An optional alpha transparency value for the \code{color} as single value in the
range of \code{0} (fully transparent) to \code{1} (fully opaque). If not provided the
fill color will either be fully opaque or use alpha information from the
color value if it is supplied in the \verb{#RRGGBBAA} format.}
}
\value{
A list object of class \code{cell_styles}.
}
\description{
\code{cell_fill()} is to be used with \code{\link[=tab_style]{tab_style()}}, which itself allows for the
setting of custom styles to one or more cells. Specifically, the call to
\code{cell_fill()} should be bound to the \code{styles} argument of \code{\link[=tab_style]{tab_style()}}.
}
\section{Examples}{


Let's use the \code{\link{exibble}} dataset to create a simple, two-column \strong{gt} table
(keeping only the \code{num} and \code{currency} columns). Styles are added with
\code{\link[=tab_style]{tab_style()}} in two separate calls (targeting different body cells with the
\code{\link[=cells_body]{cells_body()}} helper function). With the \code{cell_fill()} helper funciton we
define cells with a \code{"lightblue"} background in one instance, and \code{"gray85"}
in the other.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(num, currency) |>
  gt() |>
  fmt_number(decimals = 1) |>
  tab_style(
    style = cell_fill(color = "lightblue"),
    locations = cells_body(
      columns = num,
      rows = num >= 5000
    )
  ) |>
  tab_style(
    style = cell_fill(color = "gray85"),
    locations = cells_body(
      columns = currency,
      rows = currency < 100
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cell_fill_1.png" alt="This image of a table was generated from the first code example in the `cell_fill()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-26
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
