% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_label}
\alias{cols_label}
\title{Relabel one or more columns}
\usage{
cols_label(data, ..., .list = list2(...))
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{...}{One or more named arguments of column names from the input \code{data}
table along with their labels for display as the column labels. We can
optionally wrap the column labels with \code{\link[=md]{md()}} (to interpret text as
Markdown) or \code{\link[=html]{html()}} (to interpret text as HTML).}

\item{.list}{Allows for the use of a list as an input alternative to \code{...}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Column labels can be modified from their default values (the names of the
columns from the input table data). When you create a \strong{gt} table object
using \code{\link[=gt]{gt()}}, column names effectively become the column labels. While this
serves as a good first approximation, column names aren't often appealing as
column labels in a \strong{gt} output table. The \code{cols_label()} function
provides the flexibility to relabel one or more columns and we even have the
option to use the \code{\link[=md]{md()}} or \code{\link[=html]{html()}} helper functions for rendering column
labels from Markdown or using HTML.
}
\details{
It's important to note that while columns can be freely relabeled, we
continue to refer to columns by their original column names. Column names in
a tibble or data frame must be unique whereas column labels in \strong{gt} have
no requirement for uniqueness (which is useful for labeling columns as, say,
measurement units that may be repeated several times---usually under
different spanner column labels). Thus, we can still easily distinguish
between columns in other \strong{gt} function calls (e.g., in all of the
\verb{fmt*()} functions) even though we may lose distinguishability in column
labels once they have been relabeled.
}
\section{Figures}{

\if{html}{\figure{man_cols_label_1.png}{options: width=100\%}}

\if{html}{\figure{man_cols_label_2.png}{options: width=100\%}}
}

\section{Function ID}{

4-3
}

\examples{
# Use `countrypops` to create a gt table;
# label all the table's columns to
# present better
tab_1 <-
  countrypops \%>\%
  dplyr::select(-contains("code")) \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_label(
    country_name = "Name",
    year = "Year",
    population = "Population"
  )

# Use `countrypops` to create a gt table;
# label columns as before but make them
# bold with markdown formatting
tab_2 <-
  countrypops \%>\%
  dplyr::select(-contains("code")) \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_label(
    country_name = md("**Name**"),
    year = md("**Year**"),
    population = md("**Population**")
  )

}
\seealso{
Other Modify Columns: 
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_width}()}
}
\concept{Modify Columns}
