% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_stub_indent}
\alias{tab_stub_indent}
\title{Control indentation of row labels in the stub}
\usage{
tab_stub_indent(data, rows, indent = "increase")
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{rows}{The rows to consider for the indentation change. Can either be a
vector of row captions provided in \code{c()}, a vector of row indices, or a
helper function focused on selections. The select helper functions are:
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, and
\code{\link[=everything]{everything()}}.}

\item{indent}{An indentation directive either as a keyword describing the
indentation change or as an explicit integer value for directly setting the
indentation level. The keyword \code{"increase"} (the default) will increase the
indentation level by one; \code{"decrease"} will do the same in the reverse
direction. The starting indentation level of \code{0} means no indentation and
this values serves as a lower bound. The upper bound for indentation is at
level \code{5}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Indentation of row labels is an effective way for establishing structure in a
table stub. The \code{tab_stub_indent()} function allows for fine control over
row label indentation through either explicit definition of an indentation
level, or, by way of an indentation directive using keywords.
}
\section{Examples}{


Use \code{\link{pizzaplace}} to create a \strong{gt} table. With \code{tab_stub_indent()} we can
add indentation to targeted row labels in the stub. Here we target the
different pizza sizes and avoid selecting the repeating \code{"All Sizes"} row
label.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::bind_rows(
  pizzaplace \%>\%
    dplyr::group_by(type, size) \%>\%
    dplyr::summarize(
      sold = n(),
      income = sum(price),
      .groups = "drop_last"
    ) \%>\%
    dplyr::summarize(
      sold = sum(sold),
      income = sum(income),
      size = "All Sizes",
      .groups = "drop"
    ),
  pizzaplace \%>\%
    dplyr::group_by(type, size) \%>\%
    dplyr::summarize(
      sold = n(),
      income = sum(price),
      .groups = "drop"
    )
) \%>\%
  gt(rowname_col = "size", groupname_col = "type") \%>\%
  tab_header(title = "Pizzas Sold in 2015") \%>\%
  fmt_number(
    columns = sold,
    decimals = 0,
    use_seps = TRUE
  ) \%>\%
  fmt_currency(
    columns = income,
    currency = "USD"
  ) \%>\%
  tab_options(
    summary_row.background.color = "#ACEACE",
    row_group.background.color = "#FFEFDB",
    row_group.as_column = TRUE
  ) \%>\%
  tab_stub_indent(
    rows = matches("^L|^M|^S|^XL|^XXL"),
    indent = 2
  ) \%>\%
  tab_style(
    style = cell_fill(color = "gray95"),
    locations = list(
      cells_body(rows = matches("^All")),
      cells_stub(rows = matches("^All"))
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_stub_indent_1.png" alt="This image of a table was generated from the first code example in the `tab_stub_indent()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-6
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_caption}()},
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_info}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style_body}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
