% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_group.R
\name{grp_rm}
\alias{grp_rm}
\title{Remove one or more \strong{gt} tables from a \code{gt_group} container object}
\usage{
grp_rm(data, which)
}
\arguments{
\item{data}{A \code{gt_group} container object, typically generated through use of
the \code{\link[=gt_group]{gt_group()}} function along with one or more \code{gt_tbl} objects.}

\item{which}{An index value denoting which \code{gt_tbl} table should be removed
from the \code{gt_group} object.}
}
\value{
An object of class \code{gt_group}.
}
\description{
A \code{gt_group} object, created through use of the \code{\link[=gt_group]{gt_group()}} function, can
hold a multiple of \strong{gt} tables. However, you might want to delete one or
more \code{gt_tbl} objects table from that container. With \code{grp_rm()}, this is
possible and safe to perform. What's returned is a \code{gt_group} object with the
specified \code{gt_tbl} objects gone. The only thing you need to provide is the
index value for the \strong{gt} table within the \code{gt_group} object.
}
\section{Function ID}{

14-7
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other table group functions: 
\code{\link{grp_add}()},
\code{\link{grp_clone}()},
\code{\link{grp_options}()},
\code{\link{grp_pull}()},
\code{\link{grp_replace}()},
\code{\link{gt_group}()},
\code{\link{gt_split}()}
}
\concept{table group functions}
