% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{google_font}
\alias{google_font}
\title{Helper function for specifying a font from the \emph{Google Fonts} service}
\usage{
google_font(name)
}
\arguments{
\item{name}{\emph{Google Font name}

\verb{scalar<character>} // \strong{required}

The complete name of a font available in \emph{Google Fonts}.}
}
\value{
An object of class \code{font_css}.
}
\description{
\code{google_font()} can be used wherever a font name should be specified. There
are two instances where this helper can be used: the \code{name} argument in
\code{\link[=opt_table_font]{opt_table_font()}} (for setting a table font) and in that of \code{\link[=cell_text]{cell_text()}}
(used with \code{\link[=tab_style]{tab_style()}}). To get a helpful listing of fonts that work well
in tables, call \code{\link[=info_google_fonts]{info_google_fonts()}}.
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table of two columns and eight
rows. We'll replace missing values with em dashes using \code{\link[=sub_missing]{sub_missing()}}.
For text in the \code{time} column, we will use the font called \code{"IBM Plex Mono"}
which is available in Google Fonts. This is defined inside the
\code{google_font()} call, itself part of a vector that includes fonts returned by
\code{\link[=default_fonts]{default_fonts()}} (those fonts will serve as fallbacks just in case the font
supplied by Google Fonts is not accessible). In terms of placement, all of
this is given to the \code{font} argument of \code{\link[=cell_text]{cell_text()}} which is itself given
to the \code{style} argument of \code{\link[=tab_style]{tab_style()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(char, time) |>
  gt() |>
  sub_missing() |>
  tab_style(
    style = cell_text(
      font = c(
        google_font(name = "IBM Plex Mono"),
        default_fonts()
      )
    ),
    locations = cells_body(columns = time)
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_google_font_1.png" alt="This image of a table was generated from the first code example in the `google_font()` help file." style="width:100\%;">
}}

We can use a subset of the \code{\link{sp500}} dataset to create a small \strong{gt} table.
With \code{\link[=fmt_currency]{fmt_currency()}}, we can display a dollar sign for the first row of the
monetary values. Then, we'll set a larger font size for the table and opt to
use the \code{"Merriweather"} font by calling \code{google_font()} within
\code{\link[=opt_table_font]{opt_table_font()}}. In cases where that font may not materialize, we include
two font fallbacks: \code{"Cochin"} and the catchall \code{"Serif"} group.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sp500 |>
  dplyr::slice(1:10) |>
  dplyr::select(-volume, -adj_close) |>
  gt() |>
  fmt_currency(
    rows = 1,
    currency = "USD",
    use_seps = FALSE
  ) |>
  tab_options(table.font.size = px(20)) |>
  opt_table_font(
    font = list(
      google_font(name = "Merriweather"),
      "Cochin", "Serif"
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_google_font_2.png" alt="This image of a table was generated from the second code example in the `google_font()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-31
}

\section{Function Introduced}{

\code{v0.2.2} (August 5, 2020)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
