% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{rx_addv}
\alias{rx_addv}
\title{An ADDV-flavored clinical trial toy dataset}
\format{
A tibble with 291 rows and 20 variables:
\describe{
\item{STUDYID, STUDYIDN}{The unique study identifier and its numeric
version.}
\item{USUBJID}{The unique subject identifier.}
\item{TRTA, TRTAN}{The study intervention and its numeric version, which is
either \code{"Placebo"} (\code{1}), \code{"Drug 1"} (\code{2}), or \code{NA} (\code{3}), missing for
screen failures).}
\item{ITTFL}{Intent-to-Treat (ITT) population flag, where \code{"Y"} indicates
a subject belongs to the ITT population and \code{"N"} indicates a subject is not
in the ITT population.}
\item{AGE}{The age of a subject at baseline in years.}
\item{AAGEGR1}{The analysis age group, indicating if a subject was strictly
younger than 40 years at baseline or older.}
\item{SEX}{Sex of a subject. Can be either \code{"Male"}, \code{"Female"} or
\code{"Undifferentiated"}.}
\item{ETHNIC}{Ethnicity of a subject. Can be either \code{"Hispanic or Latino"},
\code{"Not Hispanic or Latino"} or missing (\code{""}).}
\item{BLBMI}{Body Mass Index (BMI) of a subject at baseline in kg/m2.}
\item{DVTERM}{The Protocol Deviation Term.}
\item{PARAMCD, PARAM}{The Parameter Code and decoded parameter description
for the protocol deviation.}
\item{PARCAT1}{Parameter category. Can be \code{"OVERALL"} for derived PD
summaries or \code{"PROTOCOL DEVIATION"} for individual PDs.}
\item{DVCAT}{Category for PD, indicating whether the PD is a major one or
not.}
\item{ACAT1}{Analysis category 1. Only populated for individual PDs, not for
summary scores. High level category for PDs.}
\item{AVAL}{Analysis Value. Either \code{0} or \code{1}.}
\item{CRIT1, CRIT1FL}{Analysis Criterion 1 and analysis criterion 1 flag,
indicating whether PD is related to COVID-19 or not.}
}
}
\usage{
rx_addv
}
\description{
This tibble contains artificial protocol deviation data for 180 subjects
in the Intent-to-Treat (ITT) population of the \code{GT01} study. The dataset
contains the usual parameters (\code{PARAM}, \code{PARAMCD}) for an addv. There is
summary parameter (\code{PARCAT1 == "OVERALL"}) for each subject of the \code{GT01}
ITT-population, indicating whether or not at least one major protocol
deviation (PD) occurred throughout the course of the study for the respective
subject. Individual records for protocol deviations per subject exist,
indicating which specific type of PD occurred. The additional flag \code{CRIT1FL},
shows whether a PD was related to COVID-19 or not.

Although the data was intentionally created to mimic a typical clinical
trial dataset following the CDISC format, it might not strictly comply
with CDISC ADaM rules. The intent is to showcase the workflow for clinical
table creation rather than creating a fully CDISC-compliant ADaM dataset.
}
\section{Dataset ID and Badge}{

DATA-18

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_rx_addv.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\examples{
dplyr::glimpse(rx_addv)
}
\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
