% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fontawesome-icons.R
\name{gt_fa_rank_change}
\alias{gt_fa_rank_change}
\title{Add rank change indicators to a gt table}
\usage{
gt_fa_rank_change(
  gt_object,
  column,
  palette = c("#1b7837", "lightgrey", "#762a83"),
  fa_type = c("angle-double", "arrow", "level", "chevron", "caret", "long-arrow-alt"),
  font_color = "black",
  show_text = TRUE
)
}
\arguments{
\item{gt_object}{An existing \code{gt} table object}

\item{column}{The single column that you would like to convert to rank change indicators.}

\item{palette}{A character vector of length 3. Colors can be represented as hex values or named colors. Colors should be in the order of up-arrow, no-change, down-arrow, defaults to green, grey, purple.}

\item{fa_type}{The name of the Fontawesome icon, limited to 6 types of various arrows.}

\item{font_color}{A string, indicating the color of the font, can also be returned as \code{'match'} to match the font color to the arrow palette.}

\item{show_text}{A logical indicating whether to show/hide the values in the column.}
}
\value{
a \code{gt} table
}
\description{
Takes an existing \code{gt} table and converts a column of integers
into various types of up/down arrows. Note that you need to specify a palette
of three colors, in the order of up, neutral, down. Defaults to green, grey,
purple. There are 6 supported \code{fa_type}, representing various arrows.
Note that you can use \code{font_color = 'match'} to match the palette across
arrows and text. \code{show_text = FALSE} will remove the text from the column,
resulting only in colored arrows.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{rank_table <- dplyr::tibble(x = c(1:3, -1, -2, -5, 0)) \%>\%
  gt::gt() \%>\%
  gt_fa_rank_change(x, font_color = "match")
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{fa_rank_change.png}{options: width=5\%}}
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
