% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fontawesome-icons.R
\name{gt_fa_rating}
\alias{gt_fa_rating}
\title{Add rating "stars" to a gt column}
\usage{
gt_fa_rating(
  gt_object,
  column,
  max_rating = 5,
  ...,
  color = "orange",
  icon = "star"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the numeric values should be replaced with their corresponding \code{{fontawesome}} icons.}

\item{max_rating}{The max number of icons to add, these will be added in grey to indicate "missing"}

\item{...}{Additional arguments passed to \code{fontawesome::fa()}}

\item{color}{The color of the icon, accepts named colors (\code{"orange"}) or hex strings.}

\item{icon}{The icon name, passed to \code{fontawesome::fa()}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Add rating "stars" to a gt column
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
set.seed(37)
rating_table <- mtcars \%>\%
  dplyr::select(mpg:wt) \%>\%
  dplyr::slice(1:5) \%>\%
  dplyr::mutate(rating = sample(1:5, size = 5, TRUE)) \%>\%
  gt() \%>\%
  gt_fa_rating(rating, icon = "r-project")
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{fa-stars.png}{options: width=60\%}}
}

\section{Function ID}{

2-16
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
