% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_sparkline.R
\name{gt_plt_sparkline}
\alias{gt_plt_sparkline}
\title{Add sparklines into rows of a \code{gt} table}
\usage{
gt_plt_sparkline(
  gt_object,
  column,
  type = "default",
  fig_dim = c(5, 30),
  palette = c("black", "black", "purple", "green", "lightgrey"),
  same_limit = TRUE,
  label = TRUE
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the sparkline plot should replace existing data. Note that the data \emph{must} be represented as a list of numeric values ahead of time.}

\item{type}{A string indicating the type of plot to generate, accepts \code{"default"}, \code{"points"}, \code{"shaded"}, \code{"ref_median"}, \code{'ref_mean'}, \code{"ref_iqr"}, \code{"ref_last"}. "points" will add points to every observation instead of just the high/low and final. "shaded" will add shading below the sparkline. The "ref_" options add a thin reference line based off the summary statistic chosen}

\item{fig_dim}{A vector of two numbers indicating the height/width of the plot in mm at a DPI of 25.4, defaults to \code{c(5,30)}}

\item{palette}{A character string with 5 elements indicating the colors of various components. Order matters, and palette = sparkline color, final value color, range color low, range color high, and 'type' color (eg shading or reference lines). To show a plot with no points (only the line itself), use: \code{palette = c("black", rep("transparent", 4))}.}

\item{same_limit}{A logical indicating that the plots will use the same axis range (\code{TRUE}) or have individual axis ranges (\code{FALSE}).}

\item{label}{A logical indicating whether the sparkline will have a numeric label for the last value in the vector, placed at the end of the plot.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_plt_sparkline} function takes an existing \code{gt_tbl} object and
adds sparklines via the \code{ggplot2}. Note that if you'd rather plot summary
distributions (ie density/histograms) you can instead use: \code{gtExtras::gt_plt_dist()}
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{ library(gt)
 gt_sparkline_tab <- mtcars \%>\%
    dplyr::group_by(cyl) \%>\%
    # must end up with list of data for each row in the input dataframe
    dplyr::summarize(mpg_data = list(mpg), .groups = "drop") \%>\%
    gt() \%>\%
    gt_plt_sparkline(mpg_data)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_plt_sparkline.png}{options: width=50\%}}
}

\section{Function ID}{

1-4
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_bar_pct}()},
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
