\docType{data}
\name{simul}
\alias{simul}
\title{Simulated Data}
\format{A data frame with 100 observations on the following 3 variables.
\describe{
  \item{L}{the left endpoints of the censoring interval}
  \item{R}{the right endpoints of the censoring interval}
  \item{Z}{a continuous covariate}
}}
\description{
  Simulated Interval-censored data
}
\details{
  The value \code{R = NA} means that the observation is
  right censored (occurs 2 times). If \code{L = NA}, then
  the observation is left censored (occurs 26 times). An
  observation with \code{R = L} means that the time of
  occurence of the event is known exactly (occurs 3 times).
}
\examples{
data(simul)
Fit <- gte(Surv(L, R, type="interval2") ~ Z, data=simul, z=15)
plot(Fit)
}
\references{
  Dehghan, M. H. and Duchesne, T. (2011). A generalization
  of Turnbull's estimator for nonparametric estimation of
  the conditional survival function with interval-censored
  data. \emph{Lifetime Data Analysis}, \bold{17}, 234-255.
}
\keyword{datasets}

